import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
from decision_company import read_csv_file, count_unique_values, create_subplots, set_plot_split_title, show_plots, make_xlabel, save_plot, make_ylabel, create_bar_chart, show_plots

atp_tennis = read_csv_file('atp_tennis.csv')

# Bar Chart for Surface Types:
fig3, ax3 = create_subplots()
surface_counts = count_unique_values(atp_tennis['Surface'])
create_bar_chart(ax3, surface_counts)
set_plot_split_title(ax3, 'Matches by Surface Type')
make_xlabel(ax3, 'Surface')
make_ylabel(ax3, 'Number of Matches')
save_plot('./ref_result/bar_chart.png')
show_plots()
